﻿using Spectral1.DATA_ACCESS;
using Spectral1_VBClassLibrary;
using System;
using System.Drawing;
using static Spectral1.DATA_ACCESS.DA_3DWireframe;
using static Spectral1.DATA_ACCESS.DA_Spectral;
using static Spectral1_VBClassLibrary.DataSet_Spectral;

namespace Spectral1.BUSINESS_LOGIC
{
    public class c_block
    {
        #region "================ DECLARATIONS ========================"
        static CodeGen_DS_Spectral _CGS;
        static DA_Spectral _DASP;

        private Int32 _waveform_set_id = 0;
        private Int32 _note_sector_id = 0;
        private Int32 _intensity_layer_id = 0;
        private Int32 _current_waveform_id = 0;
        public c_waveform[] waveform = new c_waveform[DA_Spectral.max_waveforms];
        #endregion

        #region "================ PROPERTIES ========================"
        public Int32 waveform_set_id { get { return _waveform_set_id; } }

        public Int32 note_sector_id { get { return _note_sector_id; } }

        public Int32 intensity_layer_id { get { return _intensity_layer_id; } }

        public Int32 current_waveform_id
        {
            get
            {
                return _current_waveform_id;
            }
            set
            {
                _current_waveform_id = value;
                _CGS.Table_waveform_harmonic.SetDefaultViewFilter("waveform_set_id = " + waveform_set_id.ToString() + " AND note_sector_id = " + note_sector_id.ToString() + " AND intensity_layer_id = " + intensity_layer_id.ToString() + " AND waveform_id = " + _current_waveform_id.ToString());
            }
        }

        public c_waveform current_waveform
        {
            get
            {
                return waveform[_current_waveform_id];
            }
        }

        #endregion

        #region "================ METHODS ========================"

        public c_block(CodeGen_DS_Spectral CGS, DA_Spectral DASP,Int32 ws, Int32 s, Int32 i)
        {
            _CGS = CGS;
            _DASP = DASP;
            _waveform_set_id = ws;
            _note_sector_id = s;
            _intensity_layer_id = i;
            for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
            {
                waveform[w] = new c_waveform(_CGS,_DASP,waveform_set_id, note_sector_id, intensity_layer_id, w);
            }
        }

        public void clear_harmonics()
        {
            for (Int32 w = 0; w <= 4; w++)
            {
                for (Int32 h = 0; h < DA_Spectral.max_harmonics; h++)
                {
                    waveform[w].clear_harmonic(h);
                }
            }
        }

        public void morph_waveforms(c_from_to_range morph_range,DA_Spectral.morph_modes morph_mode)
        {
            Int32 factor_multiple_delta = 16;
            Int32 factor_multiple_total = 0;

            for (Int32 w = 1; w <= DA_Spectral.max_waveforms - 1; w++)
            {
                factor_multiple_delta = factor_multiple_delta / 2;
                factor_multiple_total += factor_multiple_delta;

                for (Int32 h = 0; h < DA_Spectral.max_harmonics; h++)
                {
                    waveform_harmonicRow r = _CGS.Table_waveform_harmonic.GetRow(waveform_set_id, note_sector_id, intensity_layer_id, w, h);
                    Int32 level_min = waveform[morph_range.from_id].get_harmonic_level(h);
                    Int32 level_max = waveform[morph_range.to_id].get_harmonic_level(h);
                    double level_diff = level_max - level_min;

                    switch (morph_mode)
                    {
                        case DA_Spectral.morph_modes.linear:
                            double delta_level = level_diff / (double)(DA_Spectral.max_waveforms - 1);
                            waveform[w].set_harmonic_level(h, Convert.ToInt32(level_min + (delta_level * w)));
                            break;
                        case DA_Spectral.morph_modes.exponential:
                            double factor = (double)level_diff / (double)15;
                            waveform[w].set_harmonic_level(h, Convert.ToInt32(((double)factor_multiple_total * (double)factor) + (double)level_min));
                            break;
                    }

                    //Don't bother with phase
                    waveform[w].set_harmonic_phase(h, false);
                }
            }
        }

        public string copy_block_harmonics(c_block to_block)
        {
            string error_text = "";
            if ((to_block.intensity_layer_id == intensity_layer_id) && (to_block.note_sector_id == note_sector_id))
            {
                error_text = "Can't copy block to itself !";
            }
            else
            {
                for (Int32 w = 0; w < DA_Spectral.max_waveforms; w++)
                {
                    for (Int32 h = 0; h < DA_Spectral.max_harmonics; h++)
                    {
                        to_block.waveform[w].set_harmonic_level(h, waveform[w].get_harmonic_level(h));
                        to_block.waveform[w].set_harmonic_phase(h, waveform[w].get_harmonic_phase(h));
                    }
                }
            }

            return error_text;
        }

        public void copy_waveform_harmonics(Int32 source_wave_id, Int32 range_from_waveform_id, Int32 range_to_waveform_id)
        {
            for (Int32 w = range_from_waveform_id; w <= range_to_waveform_id; w++)
            {
                if (w != source_wave_id)
                    for (Int32 h = 0; h < max_harmonics; h++)
                    {
                        waveform[w].set_harmonic_level(h, waveform[source_wave_id].get_harmonic_level(h));
                        waveform[w].set_harmonic_phase(h, waveform[source_wave_id].get_harmonic_phase(h));
                    }
            }

        }

        public void adjust_harmonic_shape_for_intensity_level(c_harmonic_level_shaping_action ilsa)
        {
            double hdiff;
            double db_change;
            double level_change_perc;
            for (Int32 n = 0; n < max_note_sectors; n++)
            {
                for (Int32 w = 0; w <= 4; w++)
                {
                    for (Int32 h = 0; h < max_harmonics; h++)
                    {
                        if ((ilsa.direction == directions.up) && (h > ilsa.start_harmonic))
                        {
                            hdiff = h - ilsa.start_harmonic;
                            db_change = (hdiff / ilsa.start_harmonic) * DA_Spectral.get_dbchange_value(ilsa.db_per_octave);
                            level_change_perc = 1.0 + ((db_change / 10) * 0.5);
                            waveform[w].set_harmonic_level(h, (int)(waveform[w].get_harmonic_level(h) * level_change_perc));
                            if (waveform[w].get_harmonic_level(h) < 0) { waveform[w].set_harmonic_level(h, 0); }
                            if (waveform[w].get_harmonic_level(h) > 65535) { waveform[w].set_harmonic_level(h, 255); }
                        }
                        else if ((ilsa.direction == directions.down) && (h < ilsa.start_harmonic))
                        {
                            hdiff = ilsa.start_harmonic - h;
                            db_change = (hdiff / ilsa.start_harmonic) * DA_Spectral.get_dbchange_value(ilsa.db_per_octave);
                            level_change_perc = 1.0 + ((db_change / 10) * 0.5);
                            waveform[w].set_harmonic_level(h, (int)(waveform[w].get_harmonic_level(h) * level_change_perc));
                            if (waveform[w].get_harmonic_level(h) < 0) { waveform[w].set_harmonic_level(h, 0); }
                            if (waveform[w].get_harmonic_level(h) > 65535) { waveform[w].set_harmonic_level(h, 255); }
                        }
                    }
                }
            }
        }

        private double get_min_waveform_level_scaling()
        {
            double min_scaling = 10000;
            double scaling;
            for (int wave_id = 0; wave_id < max_waveforms; wave_id++)
            {
                scaling = waveform[wave_id].CalcLevelScaling();
                if (scaling < min_scaling) { min_scaling = scaling; }
            }

            return min_scaling;
        }

        #endregion

        #region "===================== METHODS 3D ================================="
        public void AddPolyLine3DWaveforms(ref DA_3DWireframe w, RectangleF rect,float dpi,Pen text_pen,Pen waveform_pen,Pen highlighted_waveform_pen,Pen interpolated_waveform_pen, Pen highlighted_interpolated_waveform_pen,bool flag_add_interpolated_waveforms)
        {
            PolyLine3D wp3d;
            PolyLine3D wp3d_next;
            PolyLine3D wp3d_interpolated;
            double waveform_scaling = get_min_waveform_level_scaling() * waveform_overall_scaling;

            for (int waveform_id = 0; waveform_id < DA_Spectral.max_waveforms; waveform_id++)
            {
                wp3d = waveform[waveform_id].get_3d_waveform_polyline(waveform_pen, highlighted_waveform_pen, waveform_scaling, waveform_id);
                w.w3d.PolyLinesList.Add(wp3d);

                if ((waveform_id < (DA_Spectral.max_waveforms - 1)) && (flag_add_interpolated_waveforms))
                {
                    //Add interpolated waveforms
                    wp3d_next = waveform[waveform_id + 1].get_3d_waveform_polyline(waveform_pen, highlighted_waveform_pen, waveform_scaling, waveform_id + 1);
                    for (int t = 0; t < num_interpolates; t++)
                    {
                        wp3d_interpolated = get_interpolated_polyline(wp3d, wp3d_next, t, num_interpolates, interpolated_waveform_pen, highlighted_interpolated_waveform_pen);
                        w.w3d.PolyLinesList.Add(wp3d_interpolated);
                    }
                }
            }

            //Add text
            w.AddTextTo3DWorld("W0", w.w3d.PolyLinesList, new Point3D(-(waveform_plot_width / 2), -40, -200), rect, dpi, text_pen);
            w.AddTextTo3DWorld("W4", w.w3d.PolyLinesList, new Point3D(-(waveform_plot_width / 2), -40, 200), rect, dpi, text_pen);
        }

        public void AddPolyLine3DHarmonics(ref DA_3DWireframe w, RectangleF rect, float dpi, Pen text_pen, Pen harmonic_pen, Pen highlighted_harmonic_pen, Pen interpolated_harmonic_pen, Pen highlighted_interpolated_harmonic_pen, double waveform_scaling, bool flag_add_interpolated_harmonics)
        {
            PolyLine3D wp3d;
            PolyLine3D wp3d_next;
            PolyLine3D wp3d_interpolated;

            for (int waveform_id = 0; waveform_id < DA_Spectral.max_waveforms; waveform_id++)
            {
                wp3d = waveform[waveform_id].get_3d_harmonic_polyline(harmonic_pen,highlighted_harmonic_pen,waveform_id);
                w.w3d.PolyLinesList.Add(wp3d);

                if ((waveform_id < (DA_Spectral.max_waveforms - 1)) && (flag_add_interpolated_harmonics))
                {
                    //Add interpolated waveforms
                    wp3d_next = waveform[waveform_id + 1].get_3d_harmonic_polyline(harmonic_pen, highlighted_harmonic_pen, waveform_id + 1);
                    for (int t = 0; t < num_interpolates; t++)
                    {
                        wp3d_interpolated = get_interpolated_polyline(wp3d, wp3d_next, t, num_interpolates, interpolated_harmonic_pen, highlighted_interpolated_harmonic_pen);
                        w.w3d.PolyLinesList.Add(wp3d_interpolated);
                    }
                }
            }

            //Add text
            w.AddTextTo3DWorld("W4", w.w3d.PolyLinesList, new Point3D(-(harmonic_plot_width / 2), -40 + harmonic_y_offset, 200), rect, dpi, text_pen);
            w.AddTextTo3DWorld("W0", w.w3d.PolyLinesList, new Point3D(-(harmonic_plot_width / 2), -40 + harmonic_y_offset, -200), rect, dpi, text_pen);
        }

        #endregion

    }

}
